/*********************************************
****** ģʽת֮ʹע ******
**********************************************

//	--------:----------------------------------------------------------
//	ģʽл̣
//	Normal1	--> Normal2 --> SLOW2 --> SLOW1
//	SLOW1 --> SLOW2 --> Normal2 --> Normal1
//	--------:----------------------------------------------------------
//*********************************************************************
// 			: Each Mode Switch Sequence
//	Normal1	:----------------------------------------------------------
//			: --> Normal1
//			: --> IDLE0(INTTBT release)		--> Normal1
//			: --> IDLE1(Interrupt release)	--> Normal1
//			: --> STOP (ȴ)			--> Normal1
//	Normal2	:----------------------------------------------------------
//			: --> Normal2
//			: --> IDLE2(ȴж)			--> Normal2
//			: --> STOP (ȴ)			--> Normal2
//	SLOW2	:----------------------------------------------------------
//			: --> SLOW2
//	SLOW1	:----------------------------------------------------------
//			: --> SLOW1
//			: --> SLEEP0(INTTBT release)	--> SLOW1
//			: --> SLEEP1(Interrupt release)	--> SLOW1
//			: --> STOP  (ȴ)			--> SLOW1
//	--------:----------------------------------------------------------
//*********************************************************************

/*********************************************************************
	ⲿ(HXtal) / ⲿ(LXtal),
	ֻһ, Ϊⲿɹ(P00/P01)λ.
/*********************************************************************
//	MQ6812ⲿ HXTAL/LXTALͬIO(P00/P01), ֻһ.
/*********************************************************************
ע:
	1. Enable LXtal: 趨 FSCTRL.bit.b0 = 1; --> FSCTRLʹõλԪ(bit operation)
		// ⲿ¼ʱ, 乴ѡ ext low OSC:
		// IDE¼		: Project -> Pin Setting -> ѡ ext low OSC
		// Writer¼	: ѡType -> IC typeѡͬһҳҷ -> ѡ ext low OSC
*********************************************************************/
#ifndef __OPmode_H_
#define __OPmode_H_


//--------------------------------------------------------------------------------------------------//
#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
#undef	XTAL_Low		// ⲿپ: #define(ʹþ) / #undef(þ) :
//			|........................................................................................
//			|---------> // MQ6812ⲿ¼ʱ, 乴ѡ ext low OSC:
//			|---------> // IDE¼		: Project -> Pin Setting -> ѡ ext low OSC
//			|---------> // Writer¼	: ѡType -> IC typeѡͬһҳҷ -> ѡ ext low OSC
//			.........................................................................................
//--------------------------------------------------------------------------------------------------//


//-- ض庯 --//


//-- ȫֱ --//


//	Normal1	--> Normal2 --> SLOW2 --> SLOW1
//	SLOW1 --> SLOW2 --> Normal2 --> Normal1
#define	iNor1		1
#define	iNor2		2
#define	iSlow2		3
#define	iSlow1		4
//#define	iSlow2_R	5	// ɳжϣ
//#define	iNor2_R		6	// ɳжϣ
//#define	iNor1_R		7	// ɳжϣ

#define Active_IDLE0	SYSCR2.bit.b2 = 1		// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode
#define Active_SLEEP0	SYSCR2.bit.b2 = 1		// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode

#define Active_IDLE1	SYSCR2.bit.b3 = 1		// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
#define Active_IDLE2	SYSCR2.bit.b3 = 1		// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
#define Active_SLEEP1	SYSCR2.bit.b3 = 1		// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode

#define Active_STOP	{	SYSCR1.bit.b5 = 1; SYSCR1.bit.b6 = 1; SYSCR1.bit.b7 = 1; }
					//	SYSCR1.bit.b5 = 1;		// OUTEN=1, output hold at STOP mode
					//							// stop modeעλܸ, ĩʹýλ趨Ϊλ,
					//							// λӻδ֪©
					//	SYSCR1.bit.b6 = 1;		// RELM=1,  Level-sensitive release STOP mode
					//	SYSCR1.bit.b7 = 1;		// entry STOP mode


void OpMode_Change_to(uchar iMode);
//........................| iMode: iNor1/iNor2/iSlow2/iSlow1

void XTAL_High_Config();
void HIRC_ChangeTo_8MHz();

void INTTBT_Init_OP();
void Disable_INTTBT_OP();


#endif


















